function [MachineFormat]=hdrbyteorder(hdrFile)
%[MachineFormat]=hdrbyteorder(hdrFile)
% Return machine format of a hdr file.
%Input:
%   hdrFile: hdr file name
%Output:
%   MachineFormat: 'ieee-be' or 'ieee-le'
%
%20040318, jdlee
%

if(nargin < 1),
    error('There is no input parameters.');
end

if(~ishdrfile(hdrFile)),
    hdrFile = ext_img2hdr(hdrFile);
end

fid=fopen(hdrFile,'rb','ieee-be');
fseek(fid,40,'bof');
dim = fread(fid,8,'int16');
fclose(fid);

if(dim(1)<0 | dim(1) > 15),
    MachineFormat = 'ieee-le';
else
    MachineFormat = 'ieee-be';
end


return